

<?php $__env->startSection('title', app_name() . ' | ' . __('menus.backend.sidebar.documentfilter')); ?>



<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    <?php echo e(__('menus.backend.sidebar.documentfilter')); ?>

                </h4>
            </div>
            <!--col-->
        </div>
        <!--row-->
            <hr>
        <div class="row">
                <?php echo e(Form::open(['route' => 'admin.documents.management', 'class' => 'form-horizontal', 'role' => 'form', 'method' => 'get', 'id' => 'document-filter', 'files' => true, 'target' => '_blank'])); ?>

                <div class="modal-body">
                    <div id="movemessmodel">
                    </div>
                    <div class="row">
                        <div class="col-md-8">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <?php echo e(Form::select('categories', ['' => 'Select Category'], null, ['class' => 'form-control categories1 box-size', 'data-placeholder' => trans('validation.attributes.backend.access.categories.name')])); ?>


                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <?php echo e(Form::select('file_name', ['' => 'Select File Name'], null, ['class' => 'form-control file_name box-size', 'data-placeholder' => trans('validation.attributes.backend.access.documents.file_name')])); ?>

                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <?php echo e(Form::select('filetype', ['' => 'Select File Type'], null, ['class' => 'form-control filetype box-size', 'data-placeholder' => trans('validation.attributes.backend.access.documents.file_type')])); ?>

                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <?php echo e(Form::select('user_id', ['' => 'Select User']+$users, null, ['class' => 'form-control user box-size', 'data-placeholder' => trans('labels.backend.access.documents.table.createdby')])); ?>

                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label class="text-md-right"><?php echo e(trans('labels.general.Upload_Date_Start')); ?></label>
                                        <?php echo e(Form::date('from', null, ['class' => 'form-control'])); ?>

                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label class="text-md-right"><?php echo e(trans('labels.general.Upload_Date_End')); ?></label>
                                        <?php echo e(Form::date('to', null, ['class' => 'form-control'])); ?>

                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <?php echo e(Form::submit('GO', ['class' => 'btn btn-primary', 'id' => 'savebutton'])); ?>

                            </div>
                        </div>
                    </div>
                </div>
                <?php echo e(Form::close()); ?>

           <!-- /.col-lg-12 -->
            </div>
             <!--row-->
    </div>
     <!--card-body-->
</div>
<!--card-->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('pagescript'); ?>
<script>
    FTX.Utils.documentReady(function() {
        FTX.Documents.edit.init();

    });
    $(function(){

        $('.categories1').select2({
            width: '100%',
            minimumInputLength: 2,
            allowClear: true,
            ajax: {
                url: "<?php echo e(route('admin.categories.search')); ?>",
                dataType: 'json',
                data: function(params) {
                    return {
                        q: params.term.trim()
                    };
                },
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                error: function(err) {
                    console.log(err);
                },
                cache: true
            },
            templateResult: function(data) {
                if (!data.subtitle) {
                    return data.text;
                }
                return $('<span>').html(data.text + '<br><small style="color:grey;">' + data.subtitle + '</small>');
            }
        });
        $('.file_name').select2({
            width: '100%',
            allowClear: true,
        });
        $('.filetype').select2({
            width: '100%',
            allowClear: true,
        });
        $('.user').select2({
            width: '100%',
            allowClear: true,
        });
        $('.categories1').on('change', function(e) {

            var categoryid = $(this).val();
            $.ajax({
                url:"<?php echo e(route('admin.documents.search')); ?>",
                dataType: 'JSON',
                data: {
                    categoryid: categoryid,
                }
            })
            .done(function(data) {
                $('.file_name').empty();

                $('.file_name').append(
                    '<option  value=""> Select File Name </option>');

                var file_names=data.file_name;
                $.each(file_names, function(index, value) {
                    $('.file_name').append(
                        '<option value="' + file_names[index].id + '">' + file_names[index]
                        .text + '</option>'
                    );
                });

                $('.file_name').trigger('change');
                $('.filetype').empty();

                $('.filetype').append(
                    '<option  value=""> Select File Type </option>');

                var file_types=data.file_type;
                $.each(file_types, function(index, value) {
                    $('.filetype').append(
                        '<option value="' + file_types[index].id + '">' + file_types[index]
                        .text + '</option>'
                    );
                });

                $('.filetype').trigger('change');
            })
            .fail(function(e) {
                console.log("Error:" + JSON.stringify(e));
            });

        });
    });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\mbl\doc\resources\views/backend/documents/document_filter.blade.php ENDPATH**/ ?>