<?php


use Illuminate\Support\Facades\Request;
use App\Http\Controllers\LanguageController;
use App\Http\Controllers\Backend\Categories\CategoriesController;
use App\Http\Controllers\Frontend\Auth\LoginController;
use App\Http\Controllers\OpenfilesController;
/*
 * Global Routes
 * Routes that are used between both frontend and backend.
 */

// Switch between the included languages
Route::get('lang/{lang}', [LanguageController::class, 'swap']);
Route::get('local/temp', function (Request $request) {
    /** @var Illuminate\Filesystem\FilesystemAdapter */
    $filesys = Storage::disk('local');
    return $filesys->response($request::get('url'));
 })->name('local.temp');
 Route::get('access_link/{link}', [LoginController::class,'loginByApiKey']);
 Route::get('/run-migrations', function () {
    // Run the first migration
    Artisan::call('migrate', [
        '--path' => '/database/migrations/2025_02_24_135155_add_status_to_doc_categories.php',
    ]);



    return "Migrations executed successfully.";
});
Route::group(['namespace' => 'Frontend', 'as' => 'frontend.'], function () {
    include_route_files(__DIR__.'/frontend/');
});

/*
 * Backend Routes
 * Namespaces indicate folder structure
 */
Route::group(['namespace' => 'Backend', 'prefix' => 'admin', 'as' => 'admin.', 'middleware' => 'admin'], function () {
    /*
     * These routes need view-backend permission
     * (good if you want to allow more than one group in the backend,
     * then limit the backend features by different roles or permissions)
     *
     * Note: Administrator has all permissions so you do not have to specify the administrator role everywhere.
     * These routes can not be hit if the password is expired
     */
        include_route_files(__DIR__.'/backend/');

});
Route::get('/temporary-route', [CategoriesController::class ,"temporaryroute"])->name('temporary.route');

