<?php
use Illuminate\Support\Facades\Route;

// Categories Management
Route::group(['namespace' => 'Categories'], function () {
    Route::resource('categories', 'CategoriesController', ['except' => ['show']]);
    Route::get('tree','CategoriesController@tree')->name('categories.tree');
    //For DataTables
    Route::post('categories/get', 'CategoriesTableController')->name('categories.get');

    Route::post('/give-user-category', 'CategoriesController@giveUserCategory')->name('giveUserCategory');

    Route::post('/check-user-category', 'CategoriesController@checkUserCategory')->name('checkUserCategory');
    Route::get('categories/search','CategoriesController@search')->name('categories.search');

    Route::get('categorypath', 'CategoriesController@getcategorypath')->name('getcategorypath');
    Route::get('categorypermission', 'CategoriesController@categorypermission')->name('categorypermission');
    Route::delete('deletecategoryuser','CategoriesController@deletecategoryuser')->name('deletecategoryuser');
    Route::post('/edit-user-category', 'CategoriesController@editUserCategory')->name('editUserCategory');
    Route::get('/share', 'CategoriesController@Share')->name('share');
    Route::get('download-zip', 'CategoriesController@downloadCategory')->name('download-zip');
    Route::get('downloadMultipleFiles', 'CategoriesController@downloadMultipleFiles')->name('downloadMultipleFiles');
    Route::delete('delete_files','CategoriesController@delete_files')->name('delete_files');

});
