@extends('backend.layouts.app')

@section('title', app_name() . ' | ' . __('menus.backend.sidebar.logfilter'))



@section('content')
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-sm-5">
                    <h4 class="card-title mb-0">
                        {{ __('menus.backend.sidebar.logfilter') }}
                    </h4>
                </div>
                <!--col-->
            </div>
            <!--row-->
            <hr>
            <div class="row">




                {{ Form::open(['route' => 'admin.logs.management', 'class' => 'form-horizontal', 'role' => 'form', 'method' => 'get', 'id' => 'create-permission', 'files' => true, 'target' => '_blank']) }}
                <div class="modal-body">
                    <div id="movemessmodel">
                    </div>
                    <div class="row">
                        <div class="col-md-8">
                            <div class="row">

                                <div class="col-md-12">
                                    <div class="form-group">
                                        {{ Form::select('model', ['' => 'Select Model'] + $models, null, ['class' => 'form-control model box-size', 'data-placeholder' => trans('validation.attributes.backend.access.logs.model')]) }}
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        {{ Form::select('action', ['' => 'Select Action', 'create' => 'Create', 'update' => 'Update', 'delete' => 'Delete','share'=>'Share'], null, ['class' => 'form-control action box-size', 'data-placeholder' => trans('validation.attributes.backend.access.logs.action')]) }}
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        {{ Form::select('record', ['' => 'Select Record'], null, ['class' => 'form-control record box-size', 'data-placeholder' => trans('validation.attributes.backend.access.logs.record')]) }}
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        {{ Form::select('user_id', ['' => 'Select User']+$users, null, ['class' => 'form-control user box-size', 'data-placeholder' => trans('labels.backend.access.logs.table.user')]) }}
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label class="text-md-right">{{ trans('labels.general.Upload_Date_Start') }}</label>
                                        {{ Form::date('from', null, ['class' => 'form-control']) }}
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label class="text-md-right">{{ trans('labels.general.Upload_Date_End') }}</label>
                                        {{ Form::date('to', null, ['class' => 'form-control']) }}
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                {{ Form::submit('GO', ['class' => 'btn btn-primary', 'id' => 'savebutton']) }}
                            </div>
                        </div>
                    </div>
                </div>
                {{ Form::close() }}


                <!-- /.col-lg-12 -->

            </div>
            <!--row-->

        </div>
        <!--card-body-->
    </div>
    <!--card-->
@endsection

@section('pagescript')
    <script>
        FTX.Utils.documentReady(function() {
            FTX.Logs.edit.init();
            FTX.Logs.edit.selectors.getrecordsURL = "{{ route('admin.logs.getrecords') }}";
            FTX.Logs.edit.selectors.searchURL = "{{ route('admin.categories.search') }}";
        });
    </script>

@stop
