<div class="card-body">
    <div class="row">
        <div class="col-sm-5">
            <h4 class="card-title mb-0">
                {{ __('labels.backend.access.documents.management') }}
                <small class="text-muted">{{ (isset($document)) ? __('labels.backend.access.documents.edit') : __('labels.backend.access.documents.create') }}</small>
            </h4>
        </div>
        <!--col-->
    </div>
    <!--row-->

    <hr>

    <div class="row mt-4 mb-4">
        <div class="col">
            @if(isset($document))
            <div class="form-group row">
                {{ Form::label('file_name', trans('validation.attributes.backend.access.documents.file_name'), ['class' => 'col-md-2 from-control-label required']) }}
                {{ Form::hidden('file_type',null , ['class' => 'file_type']) }}
                <div class="col-md-10">
                    {{ Form::text('name', null, ['class' => 'form-control filename', 'placeholder' => trans('validation.attributes.backend.access.documents.file_name'), 'required' => 'required']) }}
                </div>
                <!--col-->
            </div>
            <!--form-group-->
            @else
            {{ Form::hidden('file_type[]',null , ['class' => 'file_type']) }}
            {{ Form::hidden('name[]',null , ['class' => 'filename']) }}
            @endif
            <div class="form-group row">
                {{ Form::label('url', trans('validation.attributes.backend.access.documents.url'), ['class' => 'col-md-2 form-control-label required']) }}

                <div class="col-md-10">
                    @if(isset($document))
                    {{ Form::file('file', ['class' => 'form-control file']) }}
                    @else
                    {{ Form::file('file[]', ['class' => 'form-control file', 'required' => 'required', 'multiple' => 'multiple']) }}
                     @endif
                </div>
                <!--col-->
            </div>
            <div class="form-group row">
                <div class="col-md-2">
                </div>
                <div class="col-md-10">
                    @if(isset($document))
                    @include('backend.documents.includes.document_file',['document' => $document])
                    @endif
                </div>
                <!--col-->
            </div>
            <!--form-group-->

            <div class="form-group row">
                {{ Form::label('categories', trans('validation.attributes.backend.access.documents.category'), ['class' => 'col-md-2 from-control-label required']) }}
                <div class="col-md-10">
                    @if(!empty($selectedCategories))
                    {{ Form::hidden('tree', 'yes') }}
                    {{ Form::hidden('categories', $selectedCategories['id']) }}
                        <div class="card">
                            <div class="card-body">
                                <div class="row">
                                    @while ($selectedCategories)
                                        <div class="col-md-2">
                                            <p>{{ $selectedCategories->name }}</p>
                                        </div>
                                        @php
                                            $selectedCategories = $selectedCategories->parent_category;
                                        @endphp
                                        @if ($selectedCategories)
                                            <div class="col-md-1">
                                                <i class="fas fa-arrow-right"></i>
                                            </div>
                                        @endif
                                    @endwhile
                                </div>
                            </div>
                        </div>
                    @elseif(!empty($category))
                    {{ Form::hidden('tree', 'yes') }}
                    {{ Form::hidden('categories', $category['id']) }}
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                    <div class="col-md-10">
                                        <p>{{ $category->name }}</p>
                                    </div>
                            </div>
                        </div>
                    </div>
                     @else
                    {{ Form::select('categories',['' => 'Select Category'] + $Categories , null , ['class' => 'form-control categories box-size', 'data-placeholder' => trans('validation.attributes.backend.access.documents.category'),'required' => 'required']) }}
                    @endif
                </div>
                <!--col-->
            </div>
            <div class="form-group row">
                {{ Form::label('expire_date', trans('validation.attributes.backend.access.documents.expiration_date'), ['class' => 'col-md-2 form-control-label']) }}

                <div class="col-md-10">
                    {{ Form::date('expire_date', null, ['class' => 'form-control expire_date', 'min' => date('Y-m-d')]) }}
                </div>
                <!--col-->
            </div>
            <div id="childrencategories">

            </div>
            <!--form-group-->

        </div>
        <!--col-->
    </div>
    <!--row-->
</div>
<!--card-body-->

@section('pagescript')
<script type="text/javascript">

FTX.Utils.documentReady(function() {
    FTX.Documents.edit.init("{{ config('locale.languages.' . app()->getLocale())[1] }}");
});
</script>
@endsection
@section('styles')
<link rel="stylesheet" type="text/css"
href="{{asset('vendors/fancybox/dist/jquery.fancybox.min.css')}}">
@endsection
@section('scripts')
<script src="{{asset('vendors/fancybox/dist/jquery.fancybox.min.js')}}"></script>
@endsection
