<?php

/** @var \Illuminate\Database\Eloquent\Factory $factory */

use App\Models\Auth\User;
use App\Models\Category;
use Faker\Generator as Faker;

$factory->define(Category::class, function (Faker $faker) {
    return [
        'name' => $faker->name,
        'parent_category_id' => function () {
            return factory(Category::class)->create()->id;
        },
        'created_by' => function () {
            return factory(User::class)->state('active')->create()->id;
        },
    ];
});
