<?php

namespace App\Services;

use App\Models\Auth\User;
use Exception;
use Illuminate\Support\Facades\DB;

use function PHPUnit\Framework\returnSelf;

class TenantService{

    CONST APP_ID = 'doc';
    public $slug;
    public $isOwner;
    function __construct($slug)
    {
       //$this->slug = $slug;
       $this->slug = 'ste';
       if(!$this->slug){

            throw new Exception('Company not detected!');
       }
    }

    static public function initializeFromCookie() {
        $slug = request()->cookie('cp_reg');
        $service = new self($slug);
        return $service;
    }

    function connectDb(){
        // if(!\is_mbl()){
        //         DB::purge('mysql');
        //         \config(['database.connections.mysql.database' => 'tenant_'.self::APP_ID.'_'.$this->slug]);
        //     try {
        //         DB::connection()->getPdo();
        //     } catch (\Exception $e) {
        //         throw new Exception(trans('auth.this_app_is_not_activated'));
        //     }
        // }
        return $this;
    }

    function getCookie() {
        return cookie('cp_reg',$this->slug);
    }

    public function generateAccessLink($user){
        $link = $user->id.','.time().','.$this->slug;
        $link = \openssl_encrypt($link,'AES-128-ECB',\env('APP_KEY'));
        return \base64_encode($link);
    }

    static public function loginAccessLink() {
        $link = request()->route()->parameter('link');
        $link = \base64_decode($link);
        if(!$link) \abort(404);
        $link = \openssl_decrypt($link,'AES-128-ECB',\env('APP_KEY'));
        if(!$link) \abort(404);
        $link = \explode(',',$link);
        $time = \intval($link[1]);
       // if(\time() - $time > 172800) return \response()->json('The link is expired! please request new one');
        // if(!\is_mbl()){
        //     try{
        //         $service = new self($link[2]);
        //         $service->connectDb();
        //     }catch(Exception $e){
        //         return \response()->json('User not has suspended or deleted!');
        //     }
        // }
        $user = User::find(\intval($link[0]));
        if(!$user) return \response()->json('User not has suspended or deleted!');
        \auth()->login($user);
        // if(\is_mbl())
            return \redirect('admin/categories');
        // return \redirect('wizard')->withCookie($service->getCookie());
    }

}
