<?php


namespace App\Notifications\Backend\Auth;

use App\Models\User;

interface INotification
{

    /**
     * INotification constructor.
     * @param null $model
     */
    public function __construct($model = Null);

    /**
     * @param Notification $notification
     * @return bool
     */
    public static function send(Notification $notification) : bool;

    /**
     * return the id the data that wll be attached to the notification
     * @return string
     */
    public function getDataId($id);

    /**
     * notification title
     * @param User $user
     * @return string
     */
    public function getTitle($user): string;

    /**
     * notification body
     * @param User $user
     * @return string
     */
    public function getTranslatedBody($user): string;

    /**
     * notification body
     * @return string
     */
    public function getBody($lang): string;

    /**
     * firebase data with custom data
     * @return array
     */
    public function getData(): array;

    /**
     * transfer the model object
     * @return mixed
     */
    public function getCustomData();

    /**
     * transfer the model object
     * @return mixed
     */
    public function getDescription();

    /**
     * the type of notification from NotificationType Enum
     * @return int
     */
    public function getNotificationType(): int;

    /**
     * array for global user id
     * @return array
     */
    public function getUsersId();

    /**
     * array for admin id
     * @return array
     */
//    public function getAdminsId();



    /**
     * array of global users who will receive the notification
     * @return User[]
     */
    public function getUsers();


//    public function toFireBase($user): void;

    public function toDatabase($user): void;


    /**
     * notification URL
     * @param int $id
     * @return string
     */
    public function url($id): string;

    public function image(): string;

}
