<?php

namespace App\Listeners\Backend\Documents;

/**
 * Class DocumentEventListener.
 */
class DocumentEventListener
{
    /**
     * @var string
     */
    private $history_slug = 'Document';

    /**
     * @param $event
     */
    public function onCreated($event)
    {
        history()->withType($this->history_slug)
            ->withEntity($event->document->id)
            ->withText('trans("history.backend.documents.created") <strong>'.$event->document->file_name.'</strong>')
            ->withIcon('plus')
            ->withClass('bg-green')
            ->log();
    }

    /**
     * @param $event
     */
    public function onUpdated($event)
    {
        history()->withType($this->history_slug)
            ->withEntity($event->document->id)
            ->withText('trans("history.backend.documents.updated") <strong>'.$event->document->file_name.'</strong>')
            ->withIcon('save')
            ->withClass('bg-aqua')
            ->log();
    }

    /**
     * @param $event
     */
    public function onDeleted($event)
    {
        history()->withType($this->history_slug)
            ->withEntity($event->document->id)
            ->withText('trans("history.backend.documents.deleted") <strong>'.$event->document->file_name.'</strong>')
            ->withIcon('trash')
            ->withClass('bg-maroon')
            ->log();
    }

    /**
     * Register the listeners for the subscriber.
     *
     * @param \Illuminate\Events\Dispatcher $events
     */
    public function subscribe($events)
    {
        $events->listen(
            \App\Events\Backend\Documents\DocumentCreated::class,
            'App\Listeners\Backend\Documents\DocumentEventListener@onCreated'
        );

        $events->listen(
            \App\Events\Backend\Documents\DocumentUpdated::class,
            'App\Listeners\Backend\Documents\DocumentEventListener@onUpdated'
        );

        $events->listen(
            \App\Events\Backend\Documents\DocumentDeleted::class,
            'App\Listeners\Backend\Documents\DocumentEventListener@onDeleted'
        );
    }
}
