<?php

namespace App\Http\Controllers\Backend\Microsoft;

use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Models\Log;
use App\Models\Category;
use App\Models\Auth\User;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Http\Responses\ViewResponse;
use Illuminate\Support\Facades\View;
use App\Http\Responses\RedirectResponse;
use Illuminate\Support\Facades\Response;
use App\Repositories\Backend\DocumentsRepository;
use ZipArchive;
use Microsoft\Graph\Graph;
use Microsoft\Graph\Model;
use League\OAuth2\Client\Provider\GenericProvider;
use League\OAuth2\Client\Token\AccessToken;
use App\Models\Document;
use App\Models\Auth\Role;
use Illuminate\Support\Str;
use App\Services\ZipService;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Http\Request as HttpRequest;
use App\Models\Link;

class EmailController extends Controller
{

        ################ This is send email function as zip file ###########
        public function postEmail(HttpRequest $request)
        {
            try {
                $request->validate([
                    'emailTo' => 'required|email',
                    'emailSubject' => 'required',

                    'document-id' => 'required',
                ]);
                $emailTo = $request->input('emailTo');
                $emailSubject = $request->input('emailSubject');
                $emailBody = $request->input('emailBody');
                $documentId = $request->input('document-id');
                $categoryIds = explode(",", $documentId);

                $zip = new ZipArchive;
                $zipFileName = storage_path('app/') . 'download_' . date('Ymd_His')  . '.zip';

                if ($zip->open($zipFileName, ZipArchive::CREATE | ZipArchive::OVERWRITE) !== true) {
                    throw new \Exception("Failed to create zip file.");
                }

                $count = count($categoryIds);

                foreach ($categoryIds as $categoryId) {
                    $category = Category::findOrFail($categoryId);

                        // Check if there are multiple categoryIds
                        if ($count > 1) {
                            if (!is_null($category->url)) {

                                $filePath = 'uploads/' . $category->url;
                                $realFileName = 'Multi-Files';
                                $zip->addFile(storage_path('app/' . $filePath), basename($filePath));
                            }

                        }
                        else {
                            $filePath = 'uploads/' . $category->url;
                            $realFileName = pathinfo($filePath, PATHINFO_FILENAME);
                            $zip->addFile(storage_path('app/' . $filePath), basename($filePath));
                        }
                    }
                $zip->close();
                ZipService::emptyTempFolder();



                $accessToken = session('access_token');
                $recipientEmail = $emailTo;
                $graph = new Graph();
                $graph->setAccessToken($accessToken);

                // Create a new message
                $message = new Model\Message();
                $message->setSubject($emailSubject);


                            // Set the body of the message
                    $message->setBody(new Model\ItemBody([
                        'ContentType' => Model\BodyType::HTML,
                        'content' => $emailBody
                    ]));
                $recipient = new Model\Recipient();
                $recipient->setEmailAddress(new Model\EmailAddress([
                    'Address' => $recipientEmail
                ]));
                $message->setToRecipients([$recipient]);

                $attachment = [
                    '@odata.type' => '#microsoft.graph.fileAttachment',
                    'Name' => $realFileName . '.zip',
                    'ContentType' => 'application/zip',
                    'ContentBytes' => base64_encode(file_get_contents($zipFileName))
                ];

                $messagePayload = [
                    'message' => [
                        'subject' => $message->getSubject(),
                        'body' => [
                            'contentType' => 'HTML',
                            'content' => $message->getBody()->getContent()
                        ],
                        'toRecipients' => [
                            [
                                'emailAddress' => [
                                    'address' => $recipientEmail
                                ]
                            ]
                        ],
                        'attachments' => [$attachment]
                    ],
                    'saveToSentItems' => true
                ];

                $graph->createRequest("POST", "/me/sendMail")
                    ->attachBody($messagePayload)
                    ->execute();
                    unlink($zipFileName);
                return response()->json(['success' => true]);
            } catch (\Exception $e) {
                return response()->json(['error' => $e->getMessage()], 500);
            }
        }

}
