<?php

namespace App\Enums;

class IsReadNotificationEnum extends PhpEnum
{
    const no = 0;
    const yes = 1;


    public static function Labels($lang = null)
    {
        return [
            self::yes => trans( 'Yes'),
            self::no => trans( 'no'),
        ];
    }

    public static function LabelsStyle($lang = null)
    {
        return [
            self::yes => '<span class=" badge badge-sm" style="color: white;font-size: 17px; background-color: #4d52ff">' .trans( 'Yes').'</span>',
            self::no => '<span class=" badge badge-sm" style="color: white;font-size: 17px; background-color: #ff3442">' .trans( 'No').'</span>',
        ];
    }

    public static function UserNotifications($lang = null)
    {
        return [
            self::yes => trans( 'Yes'),
            self::no => trans( 'no'),
        ];
    }

    public static function AdminNotifications($lang = null)
    {
        return [
            self::yes => trans( 'Yes'),
            self::no => trans( 'no'),
        ];
    }


}
