

<?php $__env->startSection('title', app_name() . ' | ' . __('labels.frontend.auth.login_box_title')); ?>

<?php $__env->startSection('content'); ?>
    <div class="row justify-content-center align-items-center">
        <div class="col col-sm-8 align-self-center">
            <div class="card">
                <div class="card-header">
                    <strong>
                        <?php echo app('translator')->get('labels.frontend.auth.login_box_title'); ?>
                    </strong>
                </div><!--card-header-->

                <div class="card-body">
                    <?php echo e(html()->form('POST', route('frontend.auth.login.post'))->open()); ?>

                        <div class="row">
                            <div class="col">
                                <div class="form-group">
                                    <?php echo e(html()->label(__('validation.attributes.frontend.email'))->for('email')); ?>


                                    <?php echo e(html()->email('email')
                                        ->class('form-control')
                                        ->placeholder(__('validation.attributes.frontend.email'))
                                        ->attribute('maxlength', 191)
                                        ->required()); ?>

                                </div><!--form-group-->
                            </div><!--col-->
                        </div><!--row-->

                        <div class="row">
                            <div class="col">
                                <div class="form-group">
                                    <?php echo e(html()->label(__('validation.attributes.frontend.password'))->for('password')); ?>


                                    <?php echo e(html()->password('password')
                                        ->class('form-control')
                                        ->placeholder(__('validation.attributes.frontend.password'))
                                        ->required()); ?>

                                </div><!--form-group-->
                            </div><!--col-->
                        </div><!--row-->

                        <div class="row">
                            <div class="col">
                                <div class="form-group">
                                    <div class="checkbox">
                                        <?php echo e(html()->label(html()->checkbox('remember', true, 1) . ' ' . __('labels.frontend.auth.remember_me'))->for('remember')); ?>

                                    </div>
                                </div><!--form-group-->
                            </div><!--col-->
                        </div><!--row-->

                        <div class="row">
                            <div class="col">
                                <div class="form-group clearfix">
                                    <?php echo e(form_submit(__('labels.frontend.auth.login_button'))); ?>

                                </div><!--form-group-->
                            </div><!--col-->
                        </div><!--row-->

                        <?php if(config('access.captcha.login')): ?>
                            <div class="row">
                                <div class="col">
                                    @captcha
                                    <?php echo e(html()->hidden('captcha_status', 'true')); ?>

                                </div><!--col-->
                            </div><!--row-->
                        <?php endif; ?>

                        <a href="<?php echo e(route('frontend.auth.redirect')); ?>" class="microsoft-login-button">
                            <svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21">
                                <rect x="1" y="1" width="9" height="9" fill="#f25022"/>
                                <rect x="1" y="11" width="9" height="9" fill="#00a4ef"/>
                                <rect x="11" y="1" width="9" height="9" fill="#7fba00"/>
                                <rect x="11" y="11" width="9" height="9" fill="#ffb900"/>
                            </svg>
                            Login in with Microsoft
                        </a>


                        <div class="row">
                            <div class="col">
                                <div class="form-group text-right">
                                    <a href="<?php echo e(route('frontend.auth.password.reset')); ?>"><?php echo app('translator')->get('labels.frontend.passwords.forgot_password'); ?></a>
                                </div><!--form-group-->
                            </div><!--col-->
                        </div><!--row-->
                    <?php echo e(html()->form()->close()); ?>


                    <div class="row">
                        <div class="col">
                            <div class="text-center">
                                <?php echo $__env->make('frontend.auth.includes.socialite', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </div><!--col-->
                    </div><!--row-->
                </div><!--card body-->
            </div><!--card-->
        </div><!-- col-md-8 -->
    </div><!-- row -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('after-scripts'); ?>
    <?php if(config('access.captcha.login')): ?>
        @captchaScripts
    <?php endif; ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\doc\resources\views/frontend/auth/login.blade.php ENDPATH**/ ?>