<?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Backend\Documents\DocumentsController;

// Document Management
Route::group(['namespace' => 'Documents'], function () {
    Route::resource('documents', 'DocumentsController', ['except' => ['show']]);

    Route::post('/get-children-categories', [DocumentsController::class, 'getCategories'])->name('childrencategories.get');


    Route::get('management/filter','DocumentsController@managementFilter')->name('documents.filter');
    Route::get('management','DocumentsController@management')->name('documents.management');
    Route::post('management/datatables','DocumentsController@management')->name('documents.management.datatables');
    Route::get('search', 'DocumentsController@search')->name('documents.search');


    Route::post('/give-user-document', 'DocumentsController@giveUserDocument')->name('giveUserDocument');
    Route::post('/check-user-document', 'DocumentsController@checkUserDocument')->name('checkUserDocument');
    Route::delete('deletedocumentuser','DocumentsController@deletedocumentuser')->name('deletedocumentuser');
    Route::get('documentpermission', 'DocumentsController@documentpermission')->name('documentpermission');
    Route::post('/edit-user-document', 'DocumentsController@editUserDocument')->name('editUserDocument');
    Route::get('/get-history', 'DocumentsController@getAllVersion')->name('documents.getHistory');


});
