@extends('backend.layouts.app')

@section('title', app_name() . ' | ' . __('menus.backend.sidebar.documentreport'))



@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    {{ __('menus.backend.sidebar.documentreport') }}
                </h4>
            </div>
            <!--col-->
        </div>
        <!--row-->

        <div class="row mt-4">
            <div class="col" style="overflow-x:auto;">
                <div class="table-responsive">
                    <table id="documents-table" class="table" data-ajax_url="{{ route("admin.documents.management.datatables") }}">
                        <thead>
                            <tr>
                                <th>{{ trans('labels.backend.access.documents.table.serial_number') }}</th>
                                <th>{{ trans('labels.backend.access.documents.table.file_name') }}</th>
                                <th>{{ trans('labels.backend.access.documents.table.file_type') }}</th>
                                <th>{{ trans('labels.backend.access.documents.table.size') }}</th>
                                <th>{{ trans('labels.backend.access.documents.table.size_s3') }}</th>
                                <th>{{ trans('labels.backend.access.documents.table.category') }}</th>
                                <th>{{ trans('labels.backend.access.documents.table.url') }}</th>
                                <th>{{ trans('labels.backend.access.documents.table.expiration_date') }}</th>
                                <th>{{ trans('labels.backend.access.documents.table.createdat') }}</th>
                                <th>{{  trans('labels.backend.access.documents.table.createdby')}}</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
            <!--col-->
        </div>
        <!--row-->

    </div>
    <!--card-body-->
</div>
<!--card-->
@endsection
@section('styles')
<link rel="stylesheet" type="text/css"
href="{{asset('vendors/fancybox/dist/jquery.fancybox.min.css')}}">

@endsection
@section('pagescript')
<script>
    FTX.Utils.documentReady(function() {
        FTX.Documents.list.init();
    });
</script>

@stop
