// function getFileOnlineLinkAndOpen() {
//     var fileId = document.getElementById('view-file').value;

//     // Retrieve the base URL from the meta tag
//     var baseUrl = $('meta[name=\'upload-file-url\']').attr('content');

//     // Construct the URL with the fileId parameter
//     var url = baseUrl + "?fileId=" + fileId;

//     // Make an AJAX request to the constructed URL to get the file online link
//     $.ajax({
//         url: url,
//         type: 'GET',
//         success: function(data) {
//             // If the request was successful, extract the webUrl from the JSON response
//             var webUrl = data.webUrl;

//             // Open the webUrl in a new tab
//             window.open(webUrl, '_blank');
//         },
//         error: function(xhr, status, error) {
//             // Handle errors
//             console.error(error);
//         }
//     });
// }
// function getFileOnlineLinkAndOpen(documentId) {
//     // Retrieve the base URL from the meta tag
//     var baseUrl = $('meta[name=\'upload-file-url\']').attr('content');

//     // Construct the URL with the documentId parameter
//     var url = baseUrl + "?fileId=" + documentId;

//     // Make an AJAX request to the constructed URL to get the file online link
//     $.ajax({
//         url: url,
//         type: 'GET',
//         success: function(data) {
//             // If the request was successful, extract the webUrl from the JSON response
//             var webUrl = data.webUrl;

//             // Open the webUrl in a new tab
//             window.open(webUrl, '_blank');
//         },
//         error: function(xhr, status, error) {
//             // Handle errors
//             console.error(error);
//         }
//     });
// }
function getFileOnlineLinkAndOpen() {
    var fileId = document.getElementById('view-file').value;

    // Retrieve the base URL from the meta tag
    var baseUrl = $('meta[name=\'upload-file-url\']').attr('content');

    // Construct the URL with the fileId parameter
    var url = baseUrl + "?fileId=" + fileId;

    // Make an AJAX request to the constructed URL to get the file online link
    $.ajax({
        url: url,
        type: 'GET',
        success: function(data) {
            // Check if the request was successful
            if (data.success === false && data.message === 'You should buy a license to use this feature.') {
                // Display SweetAlert with the license error message
                Swal.fire({
                    icon: 'error',
                    title: 'License Required',
                    text: data.message
                });
            } else if (data.success === false && data.message === 'Please Try Again') {
                // Display SweetAlert with the generic error message
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: data.message
                });
            } else {
                // If the request was successful and no license or generic error, extract the webUrl from the JSON response
                var webUrl = data.webUrl;

                // Open the webUrl in a new tab
                window.open(webUrl, '_blank');
            }
        },
        error: function(xhr, status, error) {
            // Handle errors
            console.error(error);

            // Display generic error message
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'An error occurred. Please try again later.'
            });
        }
    });
}
