(function () {

    FTX.Documents = {

        list: {

            selectors: {
                documents_table: $('#documents-table'),
            },

            init: function () {
                $('.logs').hide();

                this.selectors.documents_table.dataTable({

                    processing: false,
                    serverSide: true,
                    ajax: {
                        url: this.selectors.documents_table.data('ajax_url'),
                        type: 'post',
                        data: {
                            name: new URLSearchParams(window.location.search).get('name'),
                            filetype: new URLSearchParams(window.location.search).get('filetype'),
                            categories: new URLSearchParams(window.location.search).get('categories'),
                            user_id: new URLSearchParams(window.location.search).get('user_id'),
                            from: new URLSearchParams(window.location.search).get('from'),
                            to: new URLSearchParams(window.location.search).get('to')
                        },
                    },
                    columns: [
                        { data: 'serial_number', name: 'serial_number' },
                        { data: 'name', name: 'name' },
                        { data: 'file_type', name: 'file_type' },
                        { data: 'size', name: 'size' },
                        { data: 'size_s3', name: 'size_s3' },
                        { data: 'category', name: 'category' },
                        { data: 'url', name: 'url' },
                        { data: 'expire_date', name: 'expire_date' },
                        { data: 'created_at', name: 'created_at' },
                        { data: 'created_by', name: 'created_by'},

                    ],
                    order: [[0, "asc"]],
                    searchDelay: 500,
                    "createdRow": function (row, data, dataIndex) {
                        FTX.Utils.dtAnchorToForm(row);
                    },
                    // initComplete: function () {
                    //     var table = this.api().table();
                    //     var searchRow = $('<tr />').prependTo($(table.header()));

                    //     table.columns().every(function (index) {
                    //         var column = this;
                    //         var title = $(column.header()).text();

                    //         var excludedColumns = [6, 9];

                    //         if (excludedColumns.includes(index)) {
                    //             $('<th />').appendTo(searchRow);
                    //             return;
                    //         }

                    //         var inputContainer = $('<th />').appendTo(searchRow);
                    //         var input = $('<input type="text" />')
                    //             .appendTo(inputContainer)
                    //             .on('keyup change', function () {
                    //                 if (column.search() !== this.value) {
                    //                     column.search(this.value).draw();
                    //                 }
                    //             });

                    //         inputContainer.addClass('position-relative');
                    //         input.addClass('w-100');

                    //         var maxLength = 20;
                    //         var truncatedTitle = title.length > maxLength ? title.substring(0, maxLength) + '...' : title;
                    //         input.attr('placeholder', truncatedTitle);
                    //     });
                    // }
                });
            }
        },

        edit: {
            selectors: {
                getCategoryURL: "",
                childrencategories: "",
                categories: jQuery(".categories"),
                filetype: jQuery(".filetype"),
                categories1:jQuery('.categories1')
            },

            init: function (locale) {
                this.setSelectors();
                this.addHandlers(locale);
                FTX.tinyMCE.init(locale);
            },
            setSelectors: function () {
                this.selectors.childrencategories = document.getElementById("childrencategories");
            },
            addHandlers: function (locale) {
                var lastSelectedCategoryId = null;
                this.selectors.categories.select2({
                    width: '100%',
                    placeholder: 'Select category',
                    allowClear: true
                });
                this.selectors.filetype.select2({
                    width: '100%',
                    placeholder: 'Select File Type',
                    allowClear: true
                });
                $('.file').on('change', function() {
                    var files = $(this).prop('files');
                    if (files.length > 0) {
                      var filenames = [];
                      var filetypes = [];

                      for (var i = 0; i < files.length; i++) {
                        var file = files[i];
                        var fileName = file.name.split('.').slice(0, -1).join('.');
                        var fileType = file.name.split('.').pop();

                        filenames[i]=fileName;
                        filetypes[i]=fileType;

                      }
                        $('.filename').val(filenames);
                      console.log( $('.filename').val());
                      $('.file_type').val(filetypes);
                    }
                  });
                $('select[name="categories"]').on('change', function() {
                    var selectedCategoryId = $(this).val();
                    lastSelectedCategoryId=selectedCategoryId;
                    var getCategoryURL = FTX.Documents.edit.selectors.getCategoryURL; // Replace with the actual URL to retrieve the children categories

                    var callback = {
                        success: function (response) {
                            var children_categories = response.children_categories;

                            FTX.Documents.edit.selectors.childrencategories.innerHTML = "";
                            if (children_categories.length !== 0) {
                                createNestedSelects(children_categories, FTX.Documents.edit.selectors.childrencategories);
                            }
                        },
                        error: function () {
                            // Error handling
                        }
                    };
                    if(selectedCategoryId!=null) {
                    $.ajax({
                        url: getCategoryURL,
                        type: 'POST',
                        data: {
                            category_id: selectedCategoryId  ||lastSelectedCategoryId
                        },
                        dataType: 'json',
                        success: callback.success,
                        error: callback.error
                    });
                  }
                });

                function createNestedSelects(categories, container) {
                    var getCategoryURL = FTX.Documents.edit.selectors.getCategoryURL; // Replace with the actual URL to retrieve the children categories
                    var labelElement = document.createElement('label');
                    labelElement.setAttribute('for', 'categories');
                    labelElement.className = 'col-md-2 from-control-label required';
                    labelElement.innerText = 'Child Category';
                    var selectElement = document.createElement('select');
                    selectElement.setAttribute('name', 'categories');
                    selectElement.className = 'form-control categories box-size';
                    selectElement.style.width = '100%';
                    var optionElement = document.createElement('option');
                    optionElement.value = '';
                    optionElement.innerText = 'Select Category';
                    selectElement.appendChild(optionElement);


                    for (var i = 0; i < categories.length; i++) {
                        var category = categories[i];

                        var optionElement = document.createElement('option');
                        optionElement.value = category.id;
                        optionElement.innerText = category.name;
                        selectElement.appendChild(optionElement);
                    }
                    var divElement = document.createElement('div');
                    divElement.className = 'col-md-10';
                    divElement.appendChild(selectElement);
                    $(selectElement).select2();
                    var divrow = document.createElement('div');
                    divrow.className = 'form-group row';
                    divrow.appendChild(labelElement);
                    divrow.appendChild(divElement);
                    container.appendChild(divrow);

                    $(selectElement).select2();

                    $(selectElement).on('change', function() {
                        var selectedCategoryId = $(this).val();
                        // Clear child selects
                        $(this).closest('.form-group.row').nextAll('.form-group.row').remove();

                if(selectedCategoryId!=null) {
                   $.ajax({
                            url: getCategoryURL,
                            type: 'POST',
                            data: {
                                category_id: selectedCategoryId  ||lastSelectedCategoryId
                            },
                            dataType: 'json',
                            success: function(response) {
                                var children_categories = response.children_categories;
                                if (children_categories.length !== 0) {
                                    createNestedSelects(children_categories, container);
                                }
                            },
                            error: function() {
                                // Error handling
                            }
                        });
                    }
                    });

                }
                $('.submit').on('click', function(e) {
                    e.preventDefault();

                    $('select[name="categories"]').each(function() {
                      if ($(this).val() === '') {
                        $(this).remove();
                      }
                    });
                    // Submit the form
                    $('form')[0].submit();
                  });
            },
        },
    }

})();
