<?php

namespace App\Models\Traits\Attributes;

use App\Models\Auth\User;
use App\Models\Category;
trait CategoryAttributes
{
    /**
     * @return string
     */
    public function getActionButtonsAttribute()
    {
            /** @var \App\Models\Auth\User */
            $user =\auth()->user();
                $permission =User::getPermission(auth()->user(),$this->id);
                $actionbutton= '<div class="btn-group action-btn">' ;
                if($this->url!=Null){
                if($user->isAdministrator() || $permission == Category::EDIT || $permission == (Category::EDIT | Category::CREATE)|| $permission == (Category::SHARE | Category::EDIT)
                || $permission == (Category::EDIT | Category::DELETE)  || $permission == (Category::EDIT | Category::CREATE | Category::DELETE) || $permission == (Category::EDIT | Category::SHARE | Category::DELETE)
                || $permission == (Category::EDIT | Category::SHARE | Category::CREATE)  || $permission == (Category::FULLPERMISSION)){
                    $actionbutton .=$this->getEditButtonAttribute(Category::EDIT, 'admin.documents.edit',$this->id);
                }
                if($user->isAdministrator() || $permission == Category::DELETE || $permission == (Category::DELETE | Category::CREATE)|| $permission == (Category::DELETE | Category::SHARE)
                || $permission == (Category::EDIT | Category::DELETE)  || $permission == (Category::EDIT | Category::CREATE | Category::DELETE) || $permission == (Category::EDIT | Category::SHARE | Category::DELETE)
                || $permission == (Category::CREATE | Category::SHARE | Category::DELETE) || $permission == (Category::FULLPERMISSION) ){
                    $actionbutton .= $this->getDeleteButtonAttribute(Category::DELETE , 'admin.documents.destroy',$this->id);
                }
                if($user->hasPermission('add_permission_document') ){
                $actionbutton .= '<button class="btn add_document_user"  data-toggle="modal" data-target="#permissiondocumentModal" data-document="'.$this->id.'" title="'.trans('labels.backend.access.categories.permission').'" data-category="'.$this->parent_category_id.'"><i class="fa fa-plus "></i></button>';}
                if($user->hasPermission('show_permission_document')){  $actionbutton .= '  <a href="'. route('admin.documentpermission',['document_id'=>$this->id]) .'" title="'.trans('labels.backend.access.categories.permission').'" target="_blank" rel="noopener noreferrer" class="btn document_user" >
                <i class="fas fa-eye"></i>
                </a>';
                }
                 }else{
                    if($user->isAdministrator() || $permission == Category::EDIT || $permission == (Category::EDIT | Category::CREATE)|| $permission == (Category::SHARE | Category::EDIT)
                    || $permission == (Category::EDIT | Category::DELETE)  || $permission == (Category::EDIT | Category::CREATE | Category::DELETE) || $permission == (Category::EDIT | Category::SHARE | Category::DELETE)
                    || $permission == (Category::EDIT | Category::SHARE | Category::CREATE)  || $permission == (Category::FULLPERMISSION) ){
                        $actionbutton .=$this->getEditButtonAttribute(Category::EDIT, 'admin.categories.edit',$this->id);
                    }
                    if($user->isAdministrator()|| $permission == Category::DELETE || $permission == (Category::DELETE | Category::CREATE)|| $permission == (Category::DELETE | Category::SHARE)
                    || $permission == (Category::EDIT | Category::DELETE)  || $permission == (Category::EDIT | Category::CREATE | Category::DELETE) || $permission == (Category::EDIT | Category::SHARE | Category::DELETE)
                    || $permission == (Category::CREATE | Category::SHARE | Category::DELETE) || $permission == (Category::FULLPERMISSION) ){
                        $actionbutton .= $this->getDeleteButtonAttribute(Category::DELETE, 'admin.categories.destroy',$this->id);
                    }
                    if($user->hasPermission('add_permission') ){
                    $actionbutton .= '<button class="btn add_category_user1"  data-toggle="modal" title="'.trans('labels.backend.access.categories.permission').'" data-target="#permissionModal" data-category="'.$this->id.'"><i class="fa fa-plus "></i></button>';}
                    if($user->hasPermission('show_permission')){  $actionbutton .= '  <a href="'. route('admin.categorypermission',['category_id'=>$this->id]) .'"  title="'.trans('labels.backend.access.categories.permission').'" target="_blank" rel="noopener noreferrer" class="btn category_user" >
                    <i class="fas fa-eye"></i>
                    </a>';
                    }
                }
                if($user->isAdministrator()||$permission == Category::SHARE || $permission == (Category::SHARE | Category::CREATE)|| $permission == (Category::DELETE | Category::SHARE)|| $permission == (Category::SHARE | Category::EDIT)
                || $permission == (Category::CREATE | Category::SHARE | Category::DELETE) || $permission == (Category::EDIT | Category::SHARE | Category::CREATE)  || $permission == (Category::EDIT | Category::SHARE | Category::DELETE)
                || $permission == (Category::FULLPERMISSION)){
                    $actionbutton .= '<button class="btn share"  data-toggle="modal" title="'.trans('buttons.general.share').'" data-target="#shareModal" data-category="'.$this->id.'"><i class="fa fa-share-alt "></i></button>';}
                    $actionbutton .= ' <a  title="'.trans('labels.general.Activity_Log').'" class="btn logs" data-category="'.$this->id.'">
                    <i class="fas fa-file"></i>
                    </a>';
                $actionbutton .=  ' </div>';
                return $actionbutton;

    }

    /**
     * @return string
     */
    public function getViewButtonAttribute()
    {
        return '<a target="_blank" href="'.route('frontend.categories.show', $this->id).'" class="btn btn-flat btn-default">
                    <i data-toggle="tooltip" data-placement="top" title="View Category" class="fa fa-eye"></i>
                </a>';
    }
public static function getAllChildCategoryIds($categoryId, &$categories)
{
    $childCategoryIds = self::where('parent_category_id', $categoryId)->pluck('id')->toArray();
    $categories = array_merge($categories, $childCategoryIds);

    foreach ($childCategoryIds as $childCategoryId) {
        self::getAllChildCategoryIds($childCategoryId, $categories);
    }
}
public static function formatCategoryPath($categoryPath) {
    $segments = explode(' / ', $categoryPath);
    $reversedSegments = array_reverse($segments);
    $formattedPath = '';

    foreach ($reversedSegments as $index => $segment) {
            $formattedPath .= $segment;

            if ($index !== count($segments) - 1) {
                $formattedPath .= ' / ';
            }
    }

    return $formattedPath;
}
public static function getCategoryPath($category) {
    $categoryPath = $category->name;

    if ($category->parent_category) {
        $parentPath = self::getCategoryPath($category->parent_category);
        $categoryPath .= ' / ' . $parentPath;
    }

    return $categoryPath;
}


public static function updateParentCategoriesSizes($categoryId, $size, $isAdding = true)
{
    $category = Category::findOrFail($categoryId);

    if ($isAdding) {
        $category->size += $size;
        $category->size_s3 += $size;
    } else {
        $category->size -= $size;
    }
    $category->save();

    if ($category->parent_category_id) {
        self::updateParentCategoriesSizes($category->parent_category_id, $size, $isAdding);
    }
}
public static function getPhotoType($category)
{
    $extension = \substr($category->url,\strrpos($category->url,'.') + 1);
    if($extension == false){
        $attachment_thumb =  asset('img/Folder.png');
    }else{
        $url = $category->tempUrl();
    if(strtolower($extension) == 'pdf') $attachment_thumb =  asset('img/pdf.png');
    else if(strtolower($extension) == 'xls' || strtolower($extension) == 'xlsx') $attachment_thumb =  asset('img/Excel.png');
    else if(strtolower($extension) == 'doc' || strtolower($extension) == 'docx') $attachment_thumb =  asset('img/word.png');
    else if(strtolower($extension) == 'ppt' || strtolower($extension) == 'pptx') $attachment_thumb = asset('img/powerpoint.png');
    else if(strtolower($extension) == 'mp4' ) $attachment_thumb =  asset('img/Mp4.png');
    else if(strtolower($extension) == 'mp3' ) $attachment_thumb =  asset('img/Mp3.png');
    else if(strtolower($extension) == 'png' || strtolower($extension) == 'jpg' ||strtolower($extension) == 'jpeg') $attachment_thumb = $url;
    else $attachment_thumb =  asset('img/File.png');

    }
    return $attachment_thumb ;
}
public static function getType($url)
{
    return \substr($url,\strrpos($url,'.') + 1);
}
}
