<?php

namespace App\Models\Auth\Traits\Methods;

use App\Models\Category;
use App\Models\Document;

trait UserMethods
{
    /**
     * @return mixed
     */
    public function canChangeEmail()
    {
        return config('access.users.change_email');
    }

    /**
     * @return bool
     */
    public function canChangePassword()
    {
        return ! app('session')->has(config('access.socialite_session_name'));
    }

    /**
     * @param bool $size
     *
     * @throws \Illuminate\Container\EntryNotFoundException
     * @return bool|\Illuminate\Contracts\Routing\UrlGenerator|mixed|string
     */
    public function getPicture($size = false)
    {
        switch ($this->avatar_type) {
            case 'gravatar':
                if (! $size) {
                    $size = config('gravatar.default.size');
                }

                return url('/img/avatar.png');

            case 'storage':
                return url('storage/'.$this->avatar_location);
        }

        // $social_avatar = $this->providers()->where('provider', $this->avatar_type)->first();

        // if ($social_avatar && strlen($social_avatar->avatar)) {
        //     return $social_avatar->avatar;
        // }

        return false;
    }

    /**
     * @param $provider
     *
     * @return bool
     */
    public function hasProvider($provider)
    {
        foreach ($this->providers as $p) {
            if ($p->provider == $provider) {
                return true;
            }
        }

        return false;
    }

    /**
     * @return mixed
     */
    public function isAdmin()
    {
        return strtolower($this->roles()->pluck('name')[0])=='admin';
    }
  /**
     * @return mixed
     */
    public function isAdministrator()
    {
        return true;
        return  strtolower($this->roles()->pluck('name')[0]) == 'root';
    }
      /**
     * @return mixed
     */
    public function isGuest()
    {
        return strtolower($this->roles()->pluck('name')[0]) == 'guest';
    }
    /**
     * @return bool
     */
    public function isActive()
    {
        return $this->status;
    }

    /**
     * @return bool
     */
    public function isConfirmed()
    {
        return $this->confirmed;
    }

    /**
     * @return bool
     */
    public function isPending()
    {
        return config('access.users.requires_approval') && ! $this->confirmed;
    }
     /**
     * @return bool
     */
    public static function hasAccess($user, $categoryId)
    {
        $category = Category::find($categoryId);

        if (!$category) {
            return false;
        }
        if ($user->categories->contains('id', $categoryId)) {
            return true;
        }
        if ($category->parent_category_id) {
            return self::hasAccess($user, $category->parent_category_id);
        }
        return false;
    }
    public static function getPermission($user, $Id)
    {
        if ($user->categories->contains('id', $Id)) {
            $permissions = $user->categories->find($Id)->pivot->permissions;
            return $permissions;
        } elseif ($user->documents->contains('id', $Id)) {
            $permissions = $user->documents->find($Id)->pivot->permissions;
            return $permissions;
        } else {
            $category = Category::find($Id);
            if ($category && $category->parent_category_id) {
                return self::getPermission($user, $category->parent_category_id);
            }
        }

        return -1;
    }
}
