<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use League\OAuth2\Client\Provider\GenericProvider;

class CheckMicrosoftToken
{
    private $provider;

    public function __construct()
    {
        $this->provider = new GenericProvider([
            'clientId'                => env('GRAPH_CLIENT_ID'),
            'clientSecret'            => env('GRAPH_CLIENT_SECRET'),
            'redirectUri'             => env('GRAPH_REDIRECT_URI'),
            'urlAuthorize'            => 'https://login.microsoftonline.com/common/oauth2/v2.0/authorize',
            'urlAccessToken'          => 'https://login.microsoftonline.com/common/oauth2/v2.0/token',
            'urlResourceOwnerDetails' => '',
            'scopes'                  => 'User.Read Mail.Send offline_access'
        ]);
    }

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $user = Auth::user();
        $accessToken = session('access_token');
        $expirationTimestamp = session('access_token_expires');

        // Check if the access token has expired
        if (time() >= $expirationTimestamp) {
            // Access token has expired, retrieve refresh token from the database
            $refreshTokenFromDB = $user->microsoft_token;

            // Use the refresh token to request a new access token
            $newAccessToken = $this->provider->getAccessToken('refresh_token', [
                'refresh_token' => $refreshTokenFromDB
            ]);

            // Store the new access token and expiration time in the session
            session([
                'access_token' => $newAccessToken->getToken(),
                'access_token_expires' => $newAccessToken->getExpires(),
                'refresh_token' => $newAccessToken->getRefreshToken() // Update the refresh token
            ]);

            // Update the user's microsoft_token column with the new refresh token
            $user->microsoft_token = $newAccessToken->getRefreshToken();
            $user->save();
        }

        return $next($request);
    }
}
