<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Exception;
use App\Models\UserMeta;
use Illuminate\Support\Facades\Log;

use Illuminate\Http\Request;

class UserMetaController extends Controller
{

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }
    
 
    public function  storeThemeFont(Request $request)
    {
        $name = UserMeta::THEME_FONT;
        UserMeta::updateOrCreate(['user_id' => auth()->id(), 'name'  => $name], ['value' => $request->font]);
        return redirect()->back()->with(['status' => 'success', 'message' => 'Theme Font Set Sucessfull']);
    }
    


    public function changeThemeMode(Request $request)
    {
        //
        try {

            $dark_mode =    $request->mode;

            UserMeta::updateOrCreate(['user_id' => auth()->id(), 'name'  => UserMeta::DARK_MODE], ['value' => '{"dark_mode":"' . $dark_mode . '"}']);

            return response()->json(['mode' => $dark_mode]);
        } catch (Exception $e) {
            return response()->json(['message'  => $e->getMessage()], 400);
        }
    }
    public function resetDefaultTheme()
    {
        //
        try {
            UserMeta::where('user_id', auth()->id())->whereIn('name', [UserMeta::DARK_MODE, UserMeta::THEME_FONT])->delete();
            return response()->json(['message'  => "Successful"]);
        } catch (Exception $e) {
            return response()->json(['message'  => $e->getMessage()], 400);
        }
    }
    

    
}
