<?php

namespace App\Http\Controllers\Backend\Logs;

use App\Http\Controllers\Controller;
use App\Http\Requests\Backend\Logs\ManageLogsRequest;
use App\Repositories\Backend\LogsRepository;
use Carbon\Carbon;
use Yajra\DataTables\Facades\DataTables;

class LogsTableController extends Controller
{
    /**
     * @var \App\Repositories\Backend\LogsRepository
     */
    protected $repository;

    /**
     * @param \App\Repositories\Backend\LogsRepository $Logs
     */
    public function __construct(LogsRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * @param \App\Http\Requests\Backend\Logs\ManageLogsRequest $request
     *
     * @return mixed
     */
    public function __invoke(ManageLogsRequest $request)
    {
        return Datatables::of($this->repository->getForDataTable())
            ->escapeColumns(['model','action','description','record_id','label'])
            ->addColumn('user', function ($logs) {
                return $logs->user_name;
            })
            ->editColumn('created_at', function ($logs) {
                return Carbon::parse($logs->created_at)->toDateTimeString();
            })
            ->make(true);
    }
}
