<?php

namespace App\Http\Controllers\Backend\Categories;

use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Auth\User;
use Yajra\DataTables\Facades\DataTables;
use App\Repositories\Backend\DocumentsRepository;

class CategoriesTableController extends Controller
{
    /**
     * @var \App\Repositories\Backend\DocumentsRepository
     */
    protected $repository;

    /**
     * @param \App\Repositories\Backend\DocumentsRepository $Documents
     */
    public function __construct(DocumentsRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * @param Request  $request
     *
     * @return mixed
     */
    public function __invoke(Request $request)
    {
        $data = $this->repository->getForDataTable();
        $listItems = '';
        foreach ($data as $document) {
            $fileType = substr($document->url, strrpos($document->url, '.') + 1);
            $folderClass = $document->url != null ? '' : 'Folder';
            $permissions = $folderClass=='Folder'?'':User::getPermission(auth()->user(), $document->id);
            $user = User::find($document->user_id);
            $username = $user?$user->full_name: '';
            $userpicture=$user?$user->picture:'' ;
            $path=$document->url;
            $fileTypeIcon = $this->getImageByType($fileType, $document);
            $thumb =  '<img class="file_icon" src="'.$fileTypeIcon.'" frameborder="0" allowfullscreen  scrolling="no" height="180" style="width:100%;min-height:100px;overflow: hidden !important;">';
            $listItems .= '<li class="data-content list" data-permission="'.$permissions.'" data-id="'.$document->id.'" >' .
                '<span class="serial_number">' . $document->serial_number . '</span>' .
                '<span class="icon">' . '<div class="td-attachment ' . $folderClass . '" data-category="' . $document->id . '">' .
                view('backend.documents.includes.document_file', ['document' => $document])->render() .
                '</div>' . '</span>' .
                '<span class="name" style="overflow: hidden;max-height: 24px;">' . $document->name . '</span>' .
                '<span class="type">' . ($fileType ?: 'Folder') . '</span>' .
                '<span class="category">' . $document->category . '</span>' .
                '<span class="version">' . ($document->version ?: '0') . '</span>'.
                '<span class="icon"><img src="'. $userpicture. '" class="img-2"></span>'.
                '<span class="owner">' .$username. '</span>' .
                '<input type="hidden" id="documentUrl" value="'.$path.'">'.
                '<span class="option" style="font-size: 18px;text-align:center;"><i class="fas fa-ellipsis-v option-list"></i></span>' .
                $thumb.
                '</li>';
        }
        if($listItems== ''){
            $listItems = '<div class="msg-data">No data available</div>';
        }
                return $listItems;
    }

    public function getImageByType($fileType, $document){
        if($fileType == false){
            $attachment_thumb =  asset('img/Folder.png');
        }else{
            $url = $document->tempUrl();;
            if(strtolower($fileType) == 'pdf') $attachment_thumb =  asset('img/pdf-icon.png');
            else if(strtolower($fileType) == 'xls' || strtolower($fileType) == 'xlsx') $attachment_thumb =  asset('img/excel-icon.png');
            else if(strtolower($fileType) == 'doc' || strtolower($fileType) == 'docx') $attachment_thumb =  asset('img/word-icon.png');
            else if(strtolower($fileType) == 'ppt' || strtolower($fileType) == 'pptx') $attachment_thumb = asset('img/powerpoint-icon.png');
            else if(strtolower($fileType) == 'mp4' ) $attachment_thumb =  asset('img/mp4-icon.png');
            else if(strtolower($fileType) == 'mp3' ) $attachment_thumb =  asset('img/mp3-icon.png');
            else if(strtolower($fileType) == 'png' || strtolower($fileType) == 'jpg' ||strtolower($fileType) == 'jpeg') $attachment_thumb = $url;
            else $attachment_thumb =  asset('img/File.png');

        }
        return $attachment_thumb ;
    }
}
